package SDB::Install::Package::ScriptHelper;
use SDB::Install::SysVars qw($path_separator);
use SDB::Install::System qw(isSameFile);
use strict;

our $icmbnd_exeutable = 'icmbnd';
our $icmbnd_new_exeutable = 'icmbnd.new';
our $icmbnd_mode = 04750;

sub binariesIcmbndSetUidRoot{
    my ($self) = @_;
    my $files = $self->{data}->{files};

    if (!defined $files || (!defined $files->{$icmbnd_exeutable} && !defined $files->{$icmbnd_new_exeutable})){
        return 1;
    }

    my $msglst = $self->getMsgLst ();

    my $msg = $msglst->addMessage ("Checking whether old '$icmbnd_exeutable' is a setuid root program.");

    $msglst = $msg->getSubMsgLst ();

    my $sapSys = $self->GetInstallation ();
    if (!defined $sapSys){
        $msglst->addWarning ("Cannot get installation object");
        return 1;
    }
    my $instance = $sapSys->getNewDBInstances ()->[0];
    if (!defined $instance){
        $msglst->addWarning ("Cannot get HDB instance object");
        return 1;
    }
    my $oldExePath = $instance->get_instanceExeDir ();
    my $newExePath = $self->getPath ();

    if (isSameFile ($oldExePath,$newExePath)){
        $msglst->addMessage ("Using the same exe directory => skipping");
        return 1;
    }

    my $oldIcmbndExe = $oldExePath . $path_separator . $icmbnd_exeutable;
    if (!-f $oldIcmbndExe){
        $msglst->addMessage ("There is no $oldIcmbndExe");
        return 1;
    }

    if (((stat (_))[2] & 07777) != $icmbnd_mode){
        $msglst->addMessage (sprintf ("Mode of $oldIcmbndExe is 0%o",(stat (_))[2]));
        return 1;
    }

    if (((stat (_))[4]) != 0){
        $msglst->addMessage ("Uid of $oldIcmbndExe is ". (stat (_))[4]);
        return 1;
    }

    my $newIcmbndExe = $newExePath . $path_separator . $icmbnd_exeutable;
    my $newNewIcmbndExe = $newExePath . $path_separator . $icmbnd_new_exeutable;

    $msg = $self->getMsgLst ()->addMessage ("Enabling setuid root bit for $newIcmbndExe");

    $msglst = $msg->getSubMsgLst ();

    if (!-f $newIcmbndExe){
        if(-f $newNewIcmbndExe){
            if (!rename ($newNewIcmbndExe, $newIcmbndExe)){
                $msglst->addWarning ("Cannot rename $newNewIcmbndExe => $newIcmbndExe: $!");
                return 1;
            }
            if (defined $files->{$icmbnd_new_exeutable}){
                $files->{$icmbnd_exeutable} = $files->{$icmbnd_new_exeutable};
                delete $files->{$icmbnd_new_exeutable};
            }
        }
        else{
            return 1;
        }
    }

    if (!chown (0,-1, $newIcmbndExe)){
        $msglst->addWarning ("Cannot chown $newIcmbndExe: $!");
        return 1;
    }

    if (defined $files->{$icmbnd_exeutable}){
        $files->{$icmbnd_exeutable}->{uid} = 0;
    }

    if (!chmod ($icmbnd_mode, $newIcmbndExe)){
        $msglst->addWarning ("Cannot chmod $newIcmbndExe: $!");
        return 1;
    }

    if (defined $files->{$icmbnd_exeutable}){
        $files->{$icmbnd_exeutable}->{mode} = $icmbnd_mode;
    }
    return 1;
}

1;
