package SDB::Install::RPM::Package;

use strict;
use base qw(SDB::Install::Base);

sub getVersion{
    return $_[0]->{Version};
}

sub getRelease{
    return $_[0]->{Release};
}

sub getName{
    return $_[0]->{Name};
}

sub getArchitecture{
    return $_[0]->{Architecture};
}

sub getDescription{
    return $_[0]->{Description};
}

sub getDistribution{
    return $_[0]->{Distribution};
}

package SDB::Install::RPM;
use strict;
use base qw(SDB::Install::Base);
use SDB::Install::System qw (which exec_program);
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Tools qw (rtrim ltrim);

our $exe = 'rpm';
our $arg_info = '-qi';
our $exePath;

if(!$isWin){
    local %ENV = %ENV;
    $ENV{PATH} = join (':', qw (/sbin /usr/sbin /bin /usr/bin), $ENV{PATH});
    $exePath = which ($exe);
}


sub _execute{
    my ($self, $arg, $rOutBuffer) = @_;
    if (!defined $exePath){
        $self->setErrorMessage ("Executable '$exe' not found");
        return undef;
    }
    my $cfg = {};
    local %ENV = %ENV;
    $ENV{LANG} = 'en_US.UTF-8';
    $ENV{LC_MESSAGES} = 'en_US.UTF-8';
    if (defined $rOutBuffer){
        $cfg->{'outLines'} = [];
    }
    my $rc = exec_program ($exePath, $arg, $cfg);
    if (defined $rOutBuffer){
        $$rOutBuffer = $cfg->{'outLines'};
    }
    return $rc;
}


sub getPackage{
    my ($self, $packageName) = @_;
    my $rpmOutput;
    my $rc = $self->_execute ([$arg_info, $packageName], \$rpmOutput);
    if (!defined $rc || $rc != 0){
        return undef;
    }
    my %packageData;
    my ($key, $value, $value1, $key2);
    my $value_pending = 0;
    my (@split_list, @pairs);
    foreach my $line (@$rpmOutput){
        if ($value_pending){
            if ($line !~ /^Distribution\s*:/){
                if ($value){
                    $value .= "\n". $line;
                }
                else{
                    $value = $line;
                }
                next;
            }
            $packageData{$key} = $value;
            $value_pending = 0;
        }
        @split_list = split (':\s', $line);
        if (@split_list == 2){
            @pairs = \@split_list;
        }
        else{
            ($value1,$key2) = split (/\s{2,}/, $split_list[1]);
            if (defined $value1){
                push @pairs, [$split_list[0], $value1], [$key2, $split_list[2]];
            }
        }
        foreach my $pair (@pairs){
            ($key,$value) = @$pair;
            if (defined $key){
                rtrim (\$key);
            }
            if (defined $value){
                ltrim (\$value);
            }
            if (!$value && $key eq 'Description'){
                $value_pending = 1;
                next;
            }
            $packageData{$key} = $value;
        }
    }
    return bless (\%packageData, 'SDB::Install::RPM::Package');
}

1;
