package SDB::Install::SAPInstance;

use strict;

use SDB::Install::BaseLegacy;
use SDB::Install::SysVars qw ($path_separator);

our @ISA = qw (SDB::Install::BaseLegacy);

our $parentdir_pattern;

{
	my $regex_path_separator = quotemeta $path_separator;
	$parentdir_pattern = $regex_path_separator . '[^' .$regex_path_separator . ']+' .
				$regex_path_separator . '*$';
}				
				
#-------------------------------------------------------------------------------
# Parameters of the constructor:
#      $instanceDir string  # '/usr/sap/<sid>' or '<sapmnt>/<sid>' in case of mount point
#     [$sourceSid   string] # source SID (mount point contains target SID)

sub new{
	my ($class, $instanceDir, $sourceSid) = @_;
	my $self = bless ({}, $class);
	
	if (defined $instanceDir){
		$self->__init__ ($instanceDir, $sourceSid);
	}
	
	return $self;
}

#-------------------------------------------------------------------------------
# Initialites this class
# Parameters:
#      $instanceDir string  # '/usr/sap/<sid>' or '<sapmnt>/<sid>' in case of mount point
#     [$sourceSid   string] # source SID (mount point contains target SID)
sub __init__{
	my ($self, $instanceDir, $sourceSid) = @_;

	$self->{_instanceDir} = $instanceDir;

	my ($saploc,$sid,$type,$instance) =
		($instanceDir =~ /(.*)[\\\/]([A-Z][A-Z0-9][A-Z0-9])[\\\/]([^\\\/]+)(\d\d)$/);

	$self->{_type} = $type;
	$self->{_nr}   = $instance;
	$self->{_sid}  = (defined $sourceSid) ? $sourceSid : $sid;

	require SDB::Install::SAPSystem;
	
	my $sysDir = $instanceDir;
	
	# get parent directory
	$sysDir =~ s/$parentdir_pattern//;
	
	$self->{_globalSidDir} = SDB::Install::SAPSystem::getGlobalSidDir ($sysDir);

	$self->{_raw} = 0;

	if (! -d $instanceDir){
		$self->{_raw} = 1;
	}
	return 1;
}

sub isTrex{
	return $_[0]->{_type} eq 'TRX';
}

sub isNewDB{
	return 0;
}

sub asString{
	my ($self, $msglst) = @_;
	my $string = $self->{_type} . $self->{_nr};
	if (defined $msglst){
		$msglst->AddMessage ($string);
	}
	return $string;
}


sub get_InstanceDir{
	return $_[0]->{_instanceDir};
}

sub get_nr{
	return $_[0]->{_nr};
}

sub get_type{
	return $_[0]->{_type};
}

sub get_profileDir{
	return $_[0]->{_globalSidDir} . $path_separator . 'profile';
}

sub get_globalDir{
	return $_[0]->{_globalSidDir} . $path_separator . 'global';
}


sub sapstartsrvIsRunning(){
	require Net::HTTP;
	
	if (defined new Net::HTTP ('Host' => sprintf('%s:5%02d13',
		$_[0]->{_host} ? $_[0]->{_host} : 'localhost', $_[0]->{_nr}))){
		
		return 1;
	}
	return 0;
}

sub get_profileName{
	my ($self,$sid,$nr,$host) = @_;
	if (!defined $sid){
		$sid = $self->{_sid};
	}
	if (!defined $nr){
		$nr = $self->{_nr};
	}
	if (!defined $host){
		$host = $self->{_host};
	}
	return sprintf('%s_%s%02d_%s',
		$sid, $self->{_type}, $nr, $host);
}

sub get_profilePattern{
	my ($self,$sid) = @_;
	if (!defined $sid){
		$sid = $self->{_sid};
	}
	return sprintf('%s_%s\d\d_\S+',
		$sid, $self->{_type});
}

sub isAutoStartEnabled{
    my ($self, $host) = @_;
    require SDB::Install::IniFile;
    my $profile = new SDB::Install::IniFile (
        $self->get_profileDir () .
        $path_separator . $self->get_profileName (undef, undef, $host));

    my $autoStart = $profile->getValue (undef, 'Autostart');
    if (defined $autoStart && $autoStart && $autoStart != 0){
        return 1;
    }
    return 0;
}

sub enableAutoStart{
    my ($self, $enable, $host, $msglst) = @_;
    if (!defined $enable){
        $enable = 1;
    }
    elsif (!$enable){
        $enable = 0;
    }
    else{
        $enable = 1;
    }

    my $errlst;
    if (!defined $msglst){
        $msglst = $self->getMsgLst ();
        $errlst = $self->getErrMsgLst ();
    }
    elsif ($msglst->isa ('SDB::Install::Base')){
        $errlst = $msglst->getErrMsgLst ();
        $msglst = $msglst->getMsgLst ();
    }

    if (!defined $errlst) {
        $errlst = $msglst;
    }

    my $onOff = ($enable) ? 'on' : 'off';
    my $messageStr = defined $host ?
        "Switching $onOff parameter 'Autostart' for host '$host'" :
        "Switching $onOff local parameter 'Autostart'";
    my $msg   = $msglst->addMessage ($messageStr);
    require SDB::Install::IniFile;
    my $profile = new SDB::Install::IniFile (
        $self->get_profileDir () .
        $path_separator . $self->get_profileName (undef, undef, $host));
    $profile->setMsgLstContext([$msg->getSubMsgLst(), $errlst]);
    $profile->setValue (undef, 'Autostart', $enable);
    if (!defined $profile->write ()){
         return undef;
    }
    return 1;
}


sub changeSid{
	my ($self, $sid) = @_;
	
	if ($sid eq $self->{_sid}){
		return 1;
	}
	my $old_sid = $self->{_sid};
	$self->{_sid} = $sid;
	
	# replace string /<OLD_SID>/HDB## =>  /<SID>/HDB##

	my $separator = quotemeta ($path_separator);
	my $pattern = $separator . $old_sid . $separator .
		'(' . $self->{_type} . '\d\d)$';
	$self->{_instanceDir} =~ s/$pattern/$path_separator$sid$path_separator$1/;

	$self->{_globalSidDir} =~ s/$old_sid$/$sid/;
	return 1;
}

sub getReservedInstanceNumbers{
    return 0;
}

1;

