package SDB::Install::TextFile;

use SDB::Install::BaseLegacy;
use SDB::Install::SysVars qw ($isWin);
use strict;

our @ISA = qw (SDB::Install::BaseLegacy);

sub new{
    my $self = shift->SUPER::new ();
    (
        $self->{fullname},
        $self->{_uid},
        $self->{_gid},
        $self->{_mode}
    ) = @_;
    if (-f $self->{fullname}){
        $self->read();
    }
    return $self;
}


sub read{
	my ($self) = @_;
	if (defined $self->{_buffer}){
		return 1;
	}
	if (!open (FD, $self->{fullname})){
		$self->AddError ("Cannot open file '$self->{fullname}'");
		return undef;
	}
	$self->{_mtime} = (stat ($self->{fullname}))[9];
	$self->{_changed} = 0;
	if (!$isWin){
		$self->{_mode} = (stat (_))[2];
		$self->{_uid} = (stat (_))[4];
		$self->{_gid} = (stat (_))[5];
	}
	my @buffer = <FD>;
	close (FD);
	$self->{_buffer} = \@buffer;
	if (!$self->parse()){
		$self->AddError ("Cannot parse '$self->{fullname}'");
		return undef;
	}
	return 1;
}

sub parse{
	return undef;
}

sub write{
	my ($self) = @_;
	if (!$self->{_changed}){
		$self->AddMessage ("File '$self->{fullname}' is up to date");
		return 1;
	}

	if ($self->{_mtime} != (stat ($self->{fullname}))[9]){
		$self->AddError ("File '$self->{fullname}' changed in the meantime");
		return undef;
	}

	my $bak_file = $self->{fullname} . '.bak';

	if (-f $bak_file){
		unlink ($bak_file);
	}

	rename ($self->{fullname}, $bak_file);

	if (!open (FD, '>'.$self->{fullname})){
		$self->AddError ("Cannot create inifile '$self->{fullname}': $!");
		rename ($bak_file, $self->{fullname});
		return undef;
	}
	my $buffer=$self->{_buffer};
	if (! print FD @$buffer ){
		$self->AddError ("Cannot write ini file '$self->{fullname}': $!");
		close (FD);
		unlink ($self->{fullname});
		rename ($bak_file, $self->{fullname});
		return undef;
	}
	close (FD);
	unlink ($bak_file);
	if (!$isWin){
        if (defined $self->{_mode}){
            chmod ($self->{_mode}, $self->{fullname});
        }
        if ($> == 0 && (defined $self->{_uid} || defined $self->{_gid})){
            my $uid = defined $self->{_uid} ? $self->{_uid} : -1;
			my $gid = defined $self->{_gid} ? $self->{_gid} : -1;
            chown ($uid, $gid, $self->{fullname});
		}
	}
	$self->{_changed} = 0;
	$self->{_mtime} = (stat ($self->{fullname}))[9];
	$self->AddMessage ("File '$self->{fullname}' updated");
	return 1;
}

sub addToBuffer{
	my ($self, $content) = @_;
	$self->{_changed} = 1;
	if ( !defined $self->{_buffer}){
		$self->{_buffer} = [$content];
		return;
	}
	push @{$self->{_buffer}},$content;
}

1;
