package SDB::Web::FcgiDispatcher;

use strict;
use FCGI;
use SDB::Web::REST;
use LCM::Slpp::SlppAdapter;
use SDB::Web::TRACE qw( TRACE_VAR_TO_FILE );

use Exporter 'import';

our @EXPORT_OK = qw( loop );
our %EXPORT_TAGS = ( all => \@EXPORT_OK );

our $REQUEST_COUNT = 0;

sub loop {
	my ($sid, $scenario, $aRequestRecievedListeners) = @_;

# The CGI module does not work with anything other than %ENV and STDIN !!!	
#	my $in = new IO::File; 
#	my $requestEnv = {};
	my %ENV = %ENV;
	my $requestEnv = \%ENV; 
	my $out = new IO::File; 
	my $err = new IO::File;	
	my $request = FCGI::Request(\*STDIN, $out, $err, $requestEnv);
	my $rest = SDB::Web::REST->new($scenario);
	while ( $request->Accept () >= 0 ) {
		# For propper parsing of XML payload - modify content type to be the fixed value of 'application/xml'
		$requestEnv->{CONTENT_TYPE} =~ s/^(application|text)\/xml.*/application\/xml/;

		$rest->setRequestContext($request);

		eval {
			for my $handler (@{$aRequestRecievedListeners}){
				$handler->notify($request);
			}
		};

		unless($rest->canHandleRequest())
		{
			$rest->respondText ( 500, "Cannot find REST mapping for requested HTTP method: " . $requestEnv->{REQUEST_METHOD} );
			next;
		}

		unless( $rest->canHandleUrl() )
		{
			$rest->respondText ( 404, "Cannot find defined REST executable for requested URL." );
			next;
		}
	
		TRACE_VAR_TO_FILE ( 'loop', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, '1_ENV', $requestEnv );
		TRACE_VAR_TO_FILE ( 'loop', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, '2_request', $request );
		TRACE_VAR_TO_FILE ( 'loop', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, '3_request->GetEnvironment()', $request->GetEnvironment() );
#		TRACE_VAR_TO_FILE ( 'loop', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, '4_cgi', $cgi );

		$rest->handleUrl();
		$request->Finish ();
	}

	$REQUEST_COUNT += 1;
	
	$request->Finish ();
}

1;
