use File::Spec;
use SDB::Install::SysVars;
use SDB::Install::System qw (isAdmin exec_program);
use SDB::Install::System::EnvVariable;

sub Register() {
    if (!$isWin) {
        return 1;
    }
    my ($self) = @_;
    my $path = $self->getPath ();

    if (defined $ENV{HDB_INSTALL_NOPATH}) {
        $self->AddMessage ("HDB_INSTALL_NOPATH is set, skipping setting PATH");
        return 1;
    }
    if (index($path, '\\usr\\sap') != -1) {
        $self->AddMessage ("\\usr\\sap appears in path, skipping setting PATH");
        return 1;
    }
    my $var = new SDB::Install::System::EnvVariable ("PATH", $path);
    my $errlst = new SDB::Install::MsgLst ();
    $var->{EnvVarValue} = $path;
    $var->{EnvVarExtend} = 'Prefix';
    $var->{EnvVarSeparator} = ';';
    $var->{EnvVarType} = 'USER';
    if (isAdmin ()) {
        $var->{EnvVarType} = 'SYSTEM';
    }
    my $msg = $self->AddMessage ("Adding to " . $var->{EnvVarType} . " PATH: $path");
    if (!defined $var->set ()) {
        $self->AddError ("Failed to set " . $envvar, $errlst);
    }
    $self->AddSubMsgLst ($msg, $var);
    return 1;
}

sub Unregister {
    if (!$isWin) {
        return 1;
    }
    if (defined $ENV{HDB_INSTALL_NOPATH}) {
        $self->AddMessage ("HDB_INSTALL_NOPATH is set, skipping removing PATH");
        return 1;
    }
    if (index($path, '\\usr\\sap') != -1) {
        $self->AddMessage ("\\usr\\sap appears in path, skipping removing PATH");
        return 1;
    }
    my ($self) = @_;
    my $path = $self->getPath ();
    my $var = new SDB::Install::System::EnvVariable ("PATH", $path);
    my $errlst = new SDB::Install::MsgLst ();
    $var->{EnvVarValue} = $path;
    $var->{EnvVarExtend} = 'Prefix';
    $var->{EnvVarSeparator} = ';';
    $var->{EnvVarType} = 'USER';
    if (isAdmin ()) {
        $var->{EnvVarType} = 'SYSTEM';
    }
    my $msg = $self->AddMessage ("Removing from " . $var->{EnvVarType} . " PATH: $path");
    if (!defined $var->unset ()) {
        $self->AddError ("Failed to remove from PATH: ", $errlst);
    }
    $self->AddSubMsgLst ($msg, $var);
    return 1;
}


sub Postinstall() {
    my (
        $self
    ) = @_;
    if ($^O ne 'MSWin32')
    {
        my $path = $self->getPath();
        my $scriptname = File::Spec->catfile( $path, 'hdbclienv.sh' );
        open(FH, "<".$scriptname) || die "Can't open hdbclienv.sh for reading";
        my @contents = <FH>;
        close(FH);
        my @replaced;
        foreach(@contents) {
            $_ =~ s/\@REPLACE_INSTALL_PATH\@/$path/g;
            push(@replaced, $_);
        }
        open(FH, ">".$scriptname) || die "Can't open hdbclienv.sh for writing";
        print FH @replaced;
        close(FH);
    }
    return 1;
}

1;

